(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7418,        263]*)
(*NotebookOutlinePosition[      8296,        293]*)
(*  CellTagsIndexPosition[      8252,        289]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData["Test Operator for Linearity"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "     This notebook defines a function which tests differential operators \
for linearity. The required test is displayed and the results are returned. \
If the operator is nonlinear, ",
  StyleBox["False",
    FontFamily->"Courier"],
  " is returned; otherwise ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". \n     The substitution group ",
  StyleBox["LinSub",
    FontWeight->"Bold"],
  " applies the definition of linearity to function evaluation and to \
differentiation of all orders.\n     You should ",
  StyleBox["Evaluate Initialization",
    FontWeight->"Bold"],
  " cells if you have not yet done so. (",
  StyleBox["Action",
    FontWeight->"Bold"],
  " Menu.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Definitions"], "Section",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{
      RowBox[{"LinSub", "=", 
        RowBox[{"{", 
          RowBox[{
          \(\((a_.\ p_ + b_.\ q_)\)[x] \[Rule] a\ p[x] + b\ q[x]\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox[\((a_.\ p_ + b_.\ q_)\), 
                  TagBox[\((r_)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
              RowBox[{
                RowBox[{"a", " ", 
                  RowBox[{
                    SuperscriptBox["p", 
                      TagBox[\((r)\),
                        Derivative],
                      MultilineFunction->None], "[", "x", "]"}]}], "+", 
                RowBox[{"b", " ", 
                  RowBox[{
                    SuperscriptBox["q", 
                      TagBox[\((r)\),
                        Derivative],
                      MultilineFunction->None], "[", "x", "]"}]}]}]}]}], 
          "}"}]}], ";"}]], "Input",
  CellMargins->{{40, Inherited}, {Inherited, Inherited}},
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TestLinear[L_, x_] := 
      Block[{a, b, u, v, result}, 
        result = 
          TrueQ[Simplify[
              L[x, a\ u + b\ v] == a\ L[x, u] + b\ L[x, v] /. LinSub]]; 
        Print[L[x, a\ u + b\ v], "\<==\>", a\ L[x, u] + b\ L[x, v]]; result]
        \)], "Input",
  CellMargins->{{40, Inherited}, {Inherited, Inherited}},
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Linear Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{\(L1[x_, y_]\), ":=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "+", \(3\ y[x]\)}]}]], 
  "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TestLinear[L1, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"3 (a u + b v)[x] + (a u + b v)'[x]==\n \n  a (3 u[x] + u'[x]) + b (3 v[x] + \
v'[x])"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[BoxData[
    RowBox[{\(L2[x_, y_]\), ":=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{"4", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        \(4\ y[x]\)}]}]], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TestLinear[L2, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"4 (a u + b v)[x] - 4 (a u + b v)'[x] + (a u + b v)''[x]==\n \n  a (4 u[x] - \
4 u'[x] + u''[x]) + \n \n   b (4 v[x] - 4 v'[x] + v''[x])"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Nonlinear Example"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    RowBox[{\(Non3[x_, y_]\), ":=", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y", "\[DoublePrime]",
            MultilineFunction->None], "[", "x", "]"}], "-", 
        RowBox[{"4", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        \(4\ y[x]\^2\)}]}]], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TestLinear[Non3, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"                2\n4 (a u + b v)[x]  - 4 (a u + b v)'[x] + (a u + b \
v)''[x]==\n \n           2\n  a (4 u[x]  - 4 u'[x] + u''[x]) + \n \n          \
  2\n   b (4 v[x]  - 4 v'[x] + v''[x])"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(False\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Algebraic Operator"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(L3[x_, y_] := k\ y\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(TestLinear[L3, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["k (a u + b v)==a k u + b k v"], "Print",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(True\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Closed]],

Cell["", "Input",
  AspectRatioFixed->True]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{567, 524},
WindowMargins->{{44, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 105, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1862, 55, 760, 22, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2647, 81, 116, 3, 56, "Section",
  Evaluatable->False,
  InitializationCell->True],
Cell[2766, 86, 1087, 28, 70, "Input",
  InitializationCell->True],
Cell[3856, 116, 405, 10, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4298, 131, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[4393, 135, 238, 7, 70, "Input"],

Cell[CellGroupData[{
Cell[4656, 146, 76, 2, 70, "Input"],
Cell[4735, 150, 160, 4, 70, "Print"],
Cell[4898, 156, 86, 3, 70, "Output"]
}, Closed]],
Cell[4999, 162, 405, 11, 70, "Input"],

Cell[CellGroupData[{
Cell[5429, 177, 76, 2, 70, "Input"],
Cell[5508, 181, 211, 4, 70, "Print"],
Cell[5722, 187, 86, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5857, 196, 94, 2, 36, "Section",
  Evaluatable->False],
Cell[5954, 200, 410, 11, 70, "Input"],

Cell[CellGroupData[{
Cell[6389, 215, 78, 2, 70, "Input"],
Cell[6470, 219, 264, 5, 70, "Print"],
Cell[6737, 226, 87, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6873, 235, 95, 2, 36, "Section",
  Evaluatable->False],
Cell[6971, 239, 77, 2, 70, "Input"],

Cell[CellGroupData[{
Cell[7073, 245, 76, 2, 70, "Input"],
Cell[7152, 249, 103, 2, 70, "Print"],
Cell[7258, 253, 86, 3, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[7371, 260, 43, 1, 24, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

